from abc import ABC, abstractmethod
from typing import Dict, List, Optional, Any
from pathlib import Path

class BaseModule(ABC):
    
    def __init__(self):
        self.name = self.__class__.__name__
        self.display_name = self.name.replace('Module', '').replace('_', ' ')
        self.source_dir = Path("to-mod-vanilla-files")
        self.output_dir = Path("modded-files")
    
    def find_file_in_extraction(self, filename: str) -> Optional[Path]:
        if not self.source_dir or not self.source_dir.exists():
            return None
        
        for file_path in self.source_dir.rglob(filename):
            if file_path.is_file():
                return file_path
        
        return None
    
    def find_gamedata_path(self) -> Optional[Path]:
        if not self.source_dir or not self.source_dir.exists():
            return None
        
        for path in self.source_dir.rglob("GameData"):
            if path.is_dir():
                return path
        
        return None
    
    @abstractmethod
    def get_predefined_configs(self) -> List[Dict[str, Any]]:
        pass
    
    @abstractmethod
    def get_custom_config(self) -> Optional[Dict[str, Any]]:
        pass
    
    @abstractmethod
    def apply_configuration(self, config: Dict[str, Any], output_path: Path) -> bool:
        pass
    
    def validate_source_files(self) -> bool:
        return self.source_dir.exists()